/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.shutdown;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.system.KeepAliveTasklet;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class ShutdownManager
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XSHTMGRT";
    private static final String TRACE_MASKF = "XSHTMGRF";
    private static final String TRACE_MASKD = "XSHTMGRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ShutdownMgr");
    private static final long SHUTDOWN_DELAY = 10L;
    private static ShutdownManager shutdownManager = null;
    private ShutdownRequest currentRequest = null;
    private ArrayList deferredRequests = new ArrayList();
    private HashSet listeners = new HashSet();
    private List shutdownScripts = new ArrayList();
    private List startupScripts = new ArrayList();
    public static final int EXECUTE_AT_SHUTDOWN = 1;
    public static final int EXECUTE_AT_STARTUP = 2;
    private static final String SHUTDOWN_SCRIPTS = "shutdownscripts";
    private static final String SHUTDOWN_SCRIPTNAME = "atShutdown";
    private static final String STARTUP_SCRIPTNAME = "atStartup";

    public static synchronized ShutdownManager getShutdownManager() {
        Trace.trace(TRACE_MASKT, "-> getShutdownManager");
        if (shutdownManager == null) {
            shutdownManager = new ShutdownManager();
        }
        Trace.trace(TRACE_MASKT, "<- getShutdownManager");
        return shutdownManager;
    }

    private ShutdownManager() {
        Trace.trace(TRACE_MASKF, "<> ShutdownManager.ctor()");
    }

    private static int nativeRestart(String applicationName, String applicationMessage, int requestType) throws IllegalArgumentException {
        int rc;
        Trace.trace(TRACE_MASKF, "-> nativeRestart()");
        try {
            ShutdownRequest request = new ShutdownRequest(new LocalizableText(applicationName), requestType, applicationMessage == null ? null : new LocalizableText(applicationMessage));
            boolean result = ShutdownManager.getShutdownManager().shutdownRequest(request);
            rc = result ? 0 : 1;
        }
        catch (ShutdownInProcessException e) {
            rc = 2;
        }
        Trace.trace(TRACE_MASKF, "<- nativeRestart()");
        return rc;
    }

    public static boolean restartApplication(LocalizableText applicationName, LocalizableText applicationMessage, Date requestDate) throws ShutdownInProcessException, IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "-> restartApplication");
        ShutdownManager mgr = ShutdownManager.getShutdownManager();
        ShutdownRequest request = new ShutdownRequest(applicationName, 1, applicationMessage, requestDate);
        Trace.trace(TRACE_MASKF, "<- restartApplication");
        boolean result = mgr.shutdownRequest(request);
        return result;
    }

    public static boolean restartConsole(LocalizableText applicationName, LocalizableText applicationMessage, Date requestDate) throws ShutdownInProcessException, IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "-> restartConsole");
        ShutdownManager mgr = ShutdownManager.getShutdownManager();
        ShutdownRequest request = new ShutdownRequest(applicationName, 2, applicationMessage, requestDate);
        boolean result = mgr.shutdownRequest(request);
        Trace.trace(TRACE_MASKF, "<- restartConsole");
        return result;
    }

    public static boolean shutdownConsole(LocalizableText applicationName, LocalizableText applicationMessage, Date requestDate) throws ShutdownInProcessException, IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "-> shutdownConsole");
        ShutdownManager mgr = ShutdownManager.getShutdownManager();
        ShutdownRequest request = new ShutdownRequest(applicationName, 3, applicationMessage, requestDate);
        boolean result = mgr.shutdownRequest(request);
        Trace.trace(TRACE_MASKF, "<- shutdownConsole");
        return result;
    }

    public static boolean poweroffConsole(LocalizableText applicationName, LocalizableText applicationMessage, Date requestDate) throws ShutdownInProcessException, IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "-> poweroffConsole");
        ShutdownManager mgr = ShutdownManager.getShutdownManager();
        ShutdownRequest request = new ShutdownRequest(applicationName, 4, applicationMessage, requestDate);
        boolean result = mgr.shutdownRequest(request);
        Trace.trace(TRACE_MASKF, "<- poweroffConsole");
        return result;
    }

    public synchronized boolean shutdownRequest(ShutdownRequest request) throws ShutdownInProcessException {
        Trace.trace(TRACE_MASKF, "-> shutdownRequest");
        if (this.currentRequest != null) {
            throw new ShutdownInProcessException(this.currentRequest);
        }
        boolean canceled = false;
        if (request.isDeferred()) {
            this.deferredRequests.add(request);
        } else {
            if (request.isCancelable()) {
                // empty if block
            }
            if (!canceled) {
                this.currentRequest = request;
                Thread reqThread = new Thread(new RequestThread(request));
                reqThread.start();
            }
        }
        Trace.trace(TRACE_MASKF, "<- shutdownRequest");
        return !canceled;
    }

    public synchronized List queryDeferredRequests() {
        if (this.deferredRequests.size() > 0) {
            return this.deferredRequests;
        }
        return null;
    }

    public synchronized boolean startDeferredRequest() throws ShutdownInProcessException, IllegalStateException {
        Trace.trace(TRACE_MASKF, "-> startDeferredRequest");
        ShutdownRequest req = this.getMostSevereDeferredRequest();
        if (req == null) {
            throw new IllegalStateException("No deferred shutdown requests to start");
        }
        req.setDeferred(false);
        Iterator i = this.deferredRequests.iterator();
        while (i.hasNext()) {
            ShutdownRequest defer = (ShutdownRequest)i.next();
            Trace.trace(TRACE_MASKF, "Deferred request is: [" + defer.toString() + "]");
        }
        boolean canceled = this.shutdownRequest(req);
        Trace.trace(TRACE_MASKF, "<- startDeferredRequest");
        return canceled;
    }

    public synchronized ShutdownRequest queryPendingRequest() {
        return this.currentRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addScript(String script, int type) {
        Trace.trace(TRACE_MASKF, "-> addScript");
        if (script == null) {
            throw new IllegalArgumentException("Script specified as null");
        }
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Invalid execution type specified");
        }
        boolean added = true;
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            List list;
            if (type == 1) {
                list = this.shutdownScripts;
                Trace.trace(TRACE_MASKF, "adding " + script + " to shutdown execution list");
            } else {
                list = this.startupScripts;
                Trace.trace(TRACE_MASKF, "adding " + script + " to startup execution list");
            }
            if (list.contains(script)) {
                added = false;
            } else {
                added = true;
                list.add(script);
            }
            if (added) {
                this.writeScripts(type);
            }
        }
        Trace.trace(TRACE_MASKF, "<- addScript");
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeScript(String script, int type) {
        Trace.trace(TRACE_MASKF, "-> removeScript");
        if (script == null) {
            throw new IllegalArgumentException("Script specified as null");
        }
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Invalid execution type specified");
        }
        boolean removed = true;
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            List list;
            if (type == 1) {
                list = this.shutdownScripts;
                Trace.trace(TRACE_MASKF, "removing " + script + " from the shutdown execution list");
            } else {
                list = this.startupScripts;
                Trace.trace(TRACE_MASKF, "removing " + script + " from the startup execution list");
            }
            removed = list.remove(script);
            if (removed) {
                this.writeScripts(type);
            }
        }
        Trace.trace(TRACE_MASKF, "<- removeScript");
        return removed;
    }

    private void writeScripts(int type) {
        Trace.trace(TRACE_MASKF, "-> writeScripts");
        try {
            List list;
            BaseFileControl.makeFilePath(SHUTDOWN_SCRIPTS);
            String filename = BaseFileControl.getFilePath(SHUTDOWN_SCRIPTS);
            if (type == 1) {
                list = this.shutdownScripts;
                filename = filename + SHUTDOWN_SCRIPTNAME;
                Trace.trace(TRACE_MASKF, "writing the shutdown execution script: " + filename);
            } else {
                list = this.startupScripts;
                filename = filename + STARTUP_SCRIPTNAME;
                Trace.trace(TRACE_MASKF, "writing the startup execution script: " + filename);
            }
            String outputname = filename + ".out";
            File file = new File(filename);
            file.delete();
            if (!list.isEmpty()) {
                PrintStream fp = new PrintStream(new FileOutputStream(file));
                fp.println("#!/bin/sh");
                fp.println("rm -f " + outputname);
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    String script = (String)i.next();
                    fp.println("echo Executing script: " + script + " >> " + outputname + " 2>&1");
                    fp.println("if [ ! -x \"" + script + "\" ]; then chmod +x " + script + "; fi" + " >> " + outputname + " 2>&1");
                    fp.println(script + " >> " + outputname + " 2>&1");
                }
                fp.close();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception writing shutdown script");
            FrameworkLog log = new FrameworkLog(classLogInfo, 71);
            log.log();
        }
        Trace.trace(TRACE_MASKF, "<- writeScripts");
    }

    private ShutdownRequest getMostSevereDeferredRequest() {
        ShutdownRequest req = null;
        Iterator i = this.deferredRequests.iterator();
        while (i.hasNext()) {
            if (req == null) {
                req = (ShutdownRequest)i.next();
                continue;
            }
            ShutdownRequest defer = (ShutdownRequest)i.next();
            if (defer.getRequestType() <= req.getRequestType()) continue;
            req = defer;
        }
        return req;
    }

    private void logShutdownRequest(ShutdownRequest request) {
        Trace.trace(TRACE_MASKF, "-> logShutdownRequest");
        FrameworkLog log = new FrameworkLog(classLogInfo, 69);
        log.add(request.toString());
        log.log(FrameworkLogAttributes.INFO_LOG);
        Trace.trace(TRACE_MASKF, "<- logShutdownRequest");
    }

    public void addShutdownListener(ShutdownListener listener) {
        Trace.trace(TRACE_MASKF, "-> addShutdownListener");
        if (listener == null) {
            throw new NullPointerException("Cannot add null listener");
        }
        this.listeners.add(listener);
        Trace.trace(TRACE_MASKF, "<- addShutdownListener");
    }

    public boolean removeShutdownListener(ShutdownListener listener) {
        Trace.trace(TRACE_MASKF, "-> removeShutdownListener");
        boolean result = this.listeners.remove(listener);
        Trace.trace(TRACE_MASKF, "<- removeShutdownListener");
        return result;
    }

    private Set getShutdownListeners() {
        Trace.trace(TRACE_MASKF, "-> getShutdownListeners");
        Set results = (Set)this.listeners.clone();
        Trace.trace(TRACE_MASKF, "<- getShutdownListeners");
        return results;
    }

    private class RequestThread
    implements Runnable {
        private ShutdownRequest request = null;

        private RequestThread(ShutdownRequest request) {
            Trace.trace(ShutdownManager.TRACE_MASKF, "-> RequestThread");
            this.request = request;
            Trace.trace(ShutdownManager.TRACE_MASKF, "<- RequestThread");
        }

        private void delay(long delayTime) {
            Trace.trace(ShutdownManager.TRACE_MASKF, "-> delay");
            long waitStart = System.currentTimeMillis();
            long tempTime = delayTime;
            while (tempTime > 0L) {
                try {
                    Trace.trace(ShutdownManager.TRACE_MASKF, "About to sleep for " + tempTime + " milliseconds");
                    Thread.currentThread();
                    Thread.sleep(tempTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                tempTime = waitStart + delayTime - System.currentTimeMillis();
            }
            Trace.trace(ShutdownManager.TRACE_MASKF, "<- delay");
        }

        private void notifyListener(ShutdownListener listener, ShutdownRequest request) {
            Trace.trace(ShutdownManager.TRACE_MASKF, "-> notifyListener");
            final ShutdownListener theListener = listener;
            final ShutdownRequest theRequest = request;
            long theDelay = 10L;
            new Thread("Shutdown Notification Thread"){

                public void run() {
                    try {
                        theListener.shutdownStarting(theRequest, 10L);
                    }
                    catch (Exception ex) {
                        new FrameworkLog(classLogInfo, 65, ex).log(FrameworkLogAttributes.INFO_LOG);
                    }
                }
            }.start();
            Trace.trace(ShutdownManager.TRACE_MASKF, "<- notifyListener");
        }

        public void run() {
            Trace.trace(ShutdownManager.TRACE_MASKF, "-> RequestThread.run");
            try {
                try {
                    Set notifyList = ShutdownManager.this.getShutdownListeners();
                    Iterator iterator = notifyList.iterator();
                    while (iterator.hasNext()) {
                        try {
                            this.notifyListener((ShutdownListener)iterator.next(), this.request);
                        }
                        catch (Exception ex) {
                            new FrameworkLog(classLogInfo, 66, ex).log(FrameworkLogAttributes.INFO_LOG);
                        }
                    }
                }
                catch (Exception ex) {
                    new FrameworkLog(classLogInfo, 67, ex).log();
                }
                int rc = this.request.getExitStatus();
                Trace.trace(ShutdownManager.TRACE_MASKF, "   RequestThread.run: shutting down local client...");
                KeepAliveTasklet.shutdownLocalClient(this.request.getRequestType(), rc);
                this.delay(10000L);
                Trace.trace(ShutdownManager.TRACE_MASKF, "   RequestThread.run: About to perform shutdown processing...");
                Trace.trace(ShutdownManager.TRACE_MASKF, "   RequestThread.run: About to shutdown the Towers...");
                Manager mgr = Manager.getManager();
                mgr.shutdown();
                ShutdownManager.this.logShutdownRequest(this.request);
                this.delay(4000L);
                Trace.trace(ShutdownManager.TRACE_MASKF, "   RequestThread.run: About to System.exit()");
                System.exit(rc);
            }
            catch (Exception ex) {
                FrameworkLog log = new FrameworkLog(classLogInfo, 68, ex);
                log.add(this.request.toString());
                log.log();
                try {
                    Runtime.getRuntime().exec(this.request.getFallbackCommand());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Trace.trace(ShutdownManager.TRACE_MASKF, "<- RequestThread.run");
        }
    }
}

